/*
          
T3Series.mqh  
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+  
//|                                    T3Moving Avereges_Channel.mq4 | 
//|                           Copyright  2006,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 3
//----  
#property indicator_color1 Red
#property indicator_color2 Lime
#property indicator_color3 Lime
//----   
#property indicator_style1 0
#property indicator_style2 4
#property indicator_style3 4
//----    --------------------------------------------------------------------------------------------------+
extern int       Channel_width = 40; //    
extern int           MA_period = 100; //     
extern int           MA_method = 0;  //  
extern int           Smooth    = 20; //   
extern int   Smooth_Curvature  = 100;//  ,      ; 
extern int           Shift     = 0;  // c     
extern int Input_Price_Customs = 0;  // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi High, 12-Heiken Ashi Low, 13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Series_buffer[];
double T3MovingBuffer[];
double UpperBuffer[];
double LowerBuffer[];
//----      
double Half_Width;
//+------------------------------------------------------------------+ 
//----+   T3Series 
//----+   T3SeriesResize 
//----+   T3SeriesAlert 
//----+   T3_ErrDescr  
#include <T3Series.mqh> 
//+------------------------------------------------------------------+ 
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+  
//| T3Moving Avereges_Channel initialization function                | 
//+------------------------------------------------------------------+  
int init() 
{  
//----    
SetIndexStyle (0,DRAW_LINE);
SetIndexStyle (1,DRAW_LINE);
SetIndexStyle (2,DRAW_LINE); 
//---- 4   s  
IndicatorBuffers(4);
SetIndexBuffer(0,T3MovingBuffer);  
SetIndexBuffer(1,UpperBuffer); 
SetIndexBuffer(2,LowerBuffer); 
SetIndexBuffer(3,Series_buffer);
//----    
SetIndexShift (0, Shift);  
SetIndexShift (1, Shift);
SetIndexShift (2, Shift);
//----   ,      
SetIndexEmptyValue(0,0); 
SetIndexEmptyValue(1,0);
SetIndexEmptyValue(2,0);
//----        
string Moving;
switch(MA_method)
  {
    case  0: Moving= "T3SMA";break;
    case  1: Moving= "T3EMA";break;
    case  2: Moving="T3SSMA";break;
    case  3: Moving="T3LWMA";break;
    default: Moving="T3SMA";
  }
IndicatorShortName (""+Moving+"_Channel( Channel_width="+Channel_width+", MA_period="+MA_period+", Shift="+Shift+")"); 
SetIndexLabel (0, ""+Moving+" ("+MA_period+")");
SetIndexLabel (1, "Upper"); 
SetIndexLabel (2, "Lower"); 
//----     
IndicatorDigits(Digits);
//----+      T3Series, nT3.number=1(    T3Series)
if (T3SeriesResize(1)!=1)return(-1);
//----       
T3SeriesAlert (0,"Smooth",Smooth);
T3SeriesAlert (0,"MA_period",MA_period);
PriceSeriesAlert(Input_Price_Customs);
if((MA_method<0)||(MA_method>3))
       Alert(" MA_method    0  3"+"    " 
                                                           +MA_method+ "   0");
//----     MA_period
if(MA_period<1)MA_period=1; 
//----   ,       
int draw_begin=MA_period+30; 
SetIndexDrawBegin(0,draw_begin);
SetIndexDrawBegin(1,draw_begin);
SetIndexDrawBegin(2,draw_begin); 
//----    
Half_Width = Channel_width*Point/2;
//----  
return(0); 
} 
//+------------------------------------------------------------------+  
//| T3Moving Avereges_Channel iteration function                     | 
//+------------------------------------------------------------------+  
int start() 
{ 
//----       
if(Bars-1<=MA_period) return(0);
//----       
double Temp_Series,Resalt;
//----+        
int reset,MaxBar,bar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
//(    counted_bars  T3Series   !!!)
if (counted_bars>0)counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1; MaxBar=Bars-1-MA_period; 
//----+     
for(bar=limit;bar>=0;bar--)Series_buffer[bar]=PriceSeries(Input_Price_Customs,bar);
//----      
//----            
if (limit>=MaxBar)
  {
   for(bar=limit;bar>=MaxBar;bar--)
     {
      T3MovingBuffer[bar]=0.0;
      UpperBuffer   [bar]=0.0; 
      LowerBuffer   [bar]=0.0;
     }
   limit=MaxBar;
  }

//----+     
for(bar=limit;bar>=0;bar--)
  {
   //----+    
   Temp_Series=iMAOnArray(Series_buffer,0,MA_period,0,MA_method, bar);
   //----+   Moving Avereges
   //----+    T3Series   0.  nT3.Length  nT3.Phase  t    (nT3.din=0)
   Resalt=T3Series(0,0,MaxBar,limit,Smooth_Curvature,Smooth,Temp_Series,bar,reset);
   //----+       
   if(reset!=0)return(-1); 
   T3MovingBuffer[bar]=Resalt; 
   //----+  
   UpperBuffer[bar]=Resalt+Half_Width;     
   LowerBuffer[bar]=Resalt-Half_Width;
   //----           
  }
//----    
return(0); 
} 

//+---------------------------------------------------------------------------+

